﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI.WebControls;
using System.Web.Security.AntiXss;
using VIRP.EFR.BO;
using VIRP_WEB.BaseCode;
using VIRP_WEB.SoaServices;

namespace VIRP_WEB.Custom.EFR
{
    public partial class LabKitDetails : EfrBasePage
    {
        private static IReadOnlyList<string> navigationSources = new List<string>
        {
            "/Custom/EFR/LabKits/LabKitInProcessOrders.aspx",
            "/Custom/EFR/Patients/PatientWorkflows.aspx"
        };

        //private readonly LabKitOrderManager labKitOrderManager;

        private WKF_CASE WkfCase
        {
            get
            {
                WKF_CASE wkfCase = null;

                if (ViewState["WkfCase"] == null)
                {
                    //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                    ViewState["WkfCase"] = wkfCase;
                }
                else
                {
                    wkfCase = ViewState["WkfCase"] as WKF_CASE;
                }

                return wkfCase;
            }
            set
            {
                ViewState["WkfCase"] = value;
            }
        }

        //private WKF_CASE_ACTIVITY Activity
        //{
        //    get
        //    {
        //        WKF_CASE_ACTIVITY activity = null;

        //        if (ViewState["Activity"] == null)
        //        {
        //            //wkfCase = ServiceInterfaceManager.REGISTRY_COHORT_DATA_GET_ALL_BY_REGISTRY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
        //            ViewState["Activity"] = activity;
        //        }
        //        else
        //        {
        //            activity = ViewState["Activity"] as WKF_CASE_ACTIVITY;
        //        }

        //        return activity;
        //    }
        //    set
        //    {
        //        ViewState["Activity"] = value;
        //    }
        //}

        //private WKF_CASE_ACTIVITY activity;
        //private PATIENT patient;
        //private WKF_CASE wCase;
        protected STD_WKFACTIVITYSTS activitySt;

        public string ConvertNullToEmptyString(string input)
        {
            return (input == null ? "" : input);
        }

        public LabKitDetails()
        {
            //labKitOrderManager = new LabKitOrderManager();

            NavigationSources = navigationSources;
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                int WKFCaseActivityId = Convert.ToInt32(AntiXssEncoder.HtmlEncode(Request.QueryString["ActivityId"], false));
                BindData(WKFCaseActivityId, false);

                SetReferringPage();
            }
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            KitOrderedDateCompareValidator.ValueToCompare = DateTime.Today.AddYears(100).ToShortDateString();
            KitSentCompareValidator.ValueToCompare = DateTime.Today.AddYears(100).ToShortDateString();
            KitReceivedDateCompareValidator.ValueToCompare = DateTime.Today.AddYears(100).ToShortDateString();
        }

        protected void BtnSave_Click(object sender, EventArgs e)
        {
            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                Save();

                SetSaveSuccessMessage();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }

        private void Save()
        {
            //wCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["WCase"]);
            WKF_CASE wCase = this.WkfCase;
            if (wCase != null)
            {
                //activity = wCase.WKF_CASE_ACTIVITies[0];
                WKF_CASE_ACTIVITY activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, wCase.WKF_CASE_ID).FirstOrDefault();
                if (activity == null)
                {
                    activity = new WKF_CASE_ACTIVITY();
                    activity.CREATED = activity.UPDATED = DateTime.Now;
                    activity.CREATEDBY = activity.UPDATEDBY = CurrentUser;
                }

                bool blnActivityWasVoided = false;

                if (activity.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided)
                {
                    activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Tracking);
                    blnActivityWasVoided = true;
                }

                activity.KIT_ORDER_DATE = Helpers.ToNullable<DateTime>(KitOrderedDate.Text.Trim());
                activity.KIT_USE_STOCK_FLAG = LabelOrderedFromStock.Text == "Yes";
                activity.REPRESENTATIVE_NAME = lblTEFSCRep.Text;
                activity.CONTACT_NAME = txtVAMCRep.Text;
                activity.ADDRESS_LINE1 = txtAddressPart1.Text;
                activity.ADDRESS_LINE2 = txtAddressPart2.Text;
                activity.ADDRESS_LINE3 = txtAddressPart3.Text;
                activity.STATE = txtState.Text;
                activity.CITY = txtCity.Text;
                activity.POSTAL_CODE = txtZip.Text;
                activity.COUNTRY = txtCountry.Text;
                activity.CONTACT_PHONE = txtPhone.Text;

                //activity.SetAsChangeTrackingRoot(true);
                activity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity);
                //Activity = activity;

                // Save ship details
                VIRP.EFR.BO.SHIPPING_DETAIL ship = VIRP.EFR.BLL.SHIPPING_DETAILManager.GetItemsByActivity(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID).FirstOrDefault();
                if (ship == null)
                {
                    ship = new VIRP.EFR.BO.SHIPPING_DETAIL();
                }
                //if (activity.SHIPPING_DETAILs.Count() != 0)
                //{   //Already exists
                //    ship = activity.SHIPPING_DETAILs[0];
                //    //activity.SetAsUpdateOnSubmit(true);
                //}
                //else
                //{
                //    ship = new SHIPPING_DETAIL();
                //    activity.SHIPPING_DETAILs.Add(ship);
                //    ship.SetAsChangeTrackingRoot(EntityState.New, true);
                //    ship.SetAsInsertOnSubmit();
                //    //activity.SetAsUpdateOnSubmit();
                //}

                ship.STD_REGISTRY_ID = UserSession.CurrentRegistryId;
                ship.WKF_CASE_ACTIVITY_ID = activity.WKF_CASE_ACTIVITY_ID;

                if (int.Parse(DDLShippingStatus.SelectedValue) > 0)
                {
                    ship.STD_SHIPMENTSTS_ID = Helpers.ToNullable<int>(DDLShippingStatus.SelectedValue);
                }
                ship.REPRESENTATIVE_NAME = txtRetVAMCContact.Text;
                ship.TRACKING_NUMBER = txtRetCourierNumber.Text;
                ship.SEND_DATE = Helpers.ToNullable<DateTime>(KitSentDate.Text);

                // Client side script changing the value to null. But does not work. 
                if (ship.STD_SHIPMENTSTS_ID != null)
                    KitReceivedDate.Text = string.Empty;
                ship.RECEIVED_DATE = Helpers.ToNullable<DateTime>(KitReceivedDate.Text);
                ship.SURVEY_RECEIVED_FLAG = (int.Parse(radQstnrReceived.SelectedValue) == 1);

                // Two entities- ship and activity
                if (ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.PatientRefused) || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.KitLost) || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.Other))
                    ship.COMMENT_TEXT = txtRetOther.Text;

                if (blnActivityWasVoided)
                {
                    ship.STD_SHIPMENTSTS_ID = null;
                    ship.COMMENT_TEXT = String.Empty;
                }

                ship.SHIPPING_DETAIL_ID = VIRP.EFR.BLL.SHIPPING_DETAILManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, ship);

                // Don't initiate any activities here
                OpenCloseReferralAndWorkflowCase(wCase, () => "Save");

                if (activity.STD_WKFACTIVITYSTS_ID == (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Received && int.Parse(radQstnrReceived.SelectedValue) == 1)
                    UpdateKitActivity(wCase, activity, ship, () => true);
                else
                    UpdateKitActivity(wCase, activity, ship, () => false);

                BindData(activity.WKF_CASE_ACTIVITY_ID, true);
            }
        }

        private void BindData(int wkfCaseActivityId, bool resetReason)
        {
            //WKF_CASE wCase = labKitOrderManager.KitOrderDetails(wkfCaseActivityId);
            WKF_CASE wCase = ServiceInterfaceManager.WKF_CASE_GET_BY_ACTIVITY(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, wkfCaseActivityId);
            if (wCase != null)
            {
                PATIENT patient = wCase.REFERRAL.PATIENT;

                //TODO - Check the default value
                //activity = wCase.WKF_CASE_ACTIVITies[0];
                WKF_CASE_ACTIVITY activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, wCase.WKF_CASE_ID).FirstOrDefault();

                if (activity != null)
                {
                    lblCaseId.Text = activity.WKF_CASE_ID.ToString();
                    LabelPatientName.Text = AntiXssEncoder.HtmlEncode(VIRP_WEB.BaseCode.Helpers.FullName(patient), false);
                    if (activity.KIT_ORDER_DATE.HasValue)
                        KitOrderedDate.Text = activity.KIT_ORDER_DATE.Value.ToShortDateString();

                    LabelOrderedFromStock.Text = AntiXssEncoder.HtmlEncode(activity.KIT_USE_STOCK_FLAG.HasValue ? activity.KIT_USE_STOCK_FLAG.Value.ToString().Replace("True", "Yes").Replace("False", "No") : "No", false);

                    lblTEFSCRep.Text = AntiXssEncoder.HtmlEncode(activity.REPRESENTATIVE_NAME, false);
                    txtVAMCRep.Text = activity.CONTACT_NAME;

                    if (String.IsNullOrEmpty(activity.ADDRESS_LINE1))
                    {
                        if (String.IsNullOrEmpty(activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE1))
                        {
                            txtAddressPart1.Text = activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE1;
                            txtAddressPart2.Text = activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE2;
                            txtAddressPart3.Text = activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETADDRESSLINE3;
                            txtCity.Text = activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETCITY;
                            txtZip.Text = activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETPOSTALCODE;
                            if (activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETSTATE_ID.HasValue)
                            {
                                txtState.Text = ConvertNullToEmptyString(VIRP.EFR.BLL.CityStateManager.GetStateByID(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETSTATE_ID.GetValueOrDefault()));
                            }

                            if (activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETCOUNTRY_ID.HasValue)
                            {
                                txtCountry.Text = ConvertNullToEmptyString(VIRP.EFR.BLL.CityStateManager.GetCountryByID(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity.WKF_CASE.REFERRAL.STD_INSTITUTION.STREETCOUNTRY_ID.GetValueOrDefault()));
                            }
                        }
                        else
                        {
                            txtAddressPart1.Text = activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE1;
                            txtAddressPart2.Text = activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE2;
                            txtAddressPart3.Text = activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGADDRESSLINE3;
                            txtCity.Text = activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGCITY;
                            txtZip.Text = activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGPOSTALCODE;
                            if (activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGSTATE_ID.HasValue)
                            {
                                txtState.Text = ConvertNullToEmptyString(VIRP.EFR.BLL.CityStateManager.GetStateByID(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGSTATE_ID.GetValueOrDefault()));
                            }

                            if (activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGCOUNTRY_ID.HasValue)
                            {
                                txtCountry.Text = ConvertNullToEmptyString(VIRP.EFR.BLL.CityStateManager.GetCountryByID(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity.WKF_CASE.REFERRAL.STD_INSTITUTION.MAILINGCOUNTRY_ID.GetValueOrDefault()));
                            }
                        }
                    }
                    else
                    {
                        txtAddressPart1.Text = activity.ADDRESS_LINE1;
                        txtAddressPart2.Text = activity.ADDRESS_LINE2;
                        txtAddressPart3.Text = activity.ADDRESS_LINE3;
                        txtState.Text = activity.STATE;
                        txtCity.Text = activity.CITY;
                        txtZip.Text = activity.POSTAL_CODE;
                        txtCountry.Text = activity.COUNTRY;
                    }

                    txtPhone.Text = activity.CONTACT_PHONE;

                    if (activity.WKF_CASE != null && activity.WKF_CASE.STD_WKFCASETYPE != null)
                        lblKitType.Text = AntiXssEncoder.HtmlEncode(activity.WKF_CASE.STD_WKFCASETYPE.CODE, false);

                    if (activity.STD_WKFACTIVITYSTS != null)
                    {
                        activitySt = activity.STD_WKFACTIVITYSTS;

                        if (activitySt.ID == Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided))
                            MakeControlsReadOnly(this.Controls);
                        else
                            MakeControlsWriteable(this.Controls);

                        ViewState["OrderType"] = activitySt.ID;
                    }
                    else
                        MakeControlsWriteable(this.Controls);

                    //This is not updatable. It is maintained in REFERRAL
                    VIRP.CRS.BO.REFERRAL_REG efrReferral = VIRP.CRS.BLL.REFERRAL_REGManager.GetItemByReferral(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity.WKF_CASE.REFERRAL.REFERRAL_ID);
                    if (efrReferral != null)
                    {
                        //lblRetPhoneNumber.Text = activity.WKF_CASE.REFERRAL.VAMC_CONTACT_PHONE;
                        lblRetPhoneNumber.Text = efrReferral.VAMC_CONTACT_PHONE;
                        txtRetVAMCContact.Text = efrReferral.VAMC_CONTACT_NAME;
                    }
                    lblRetVAMCFacility.Text = AntiXssEncoder.HtmlEncode(activity.WKF_CASE.REFERRAL.STD_INSTITUTION.NAME, false);
                    //This is not editable. Not maintained in _activity or shipping tables
                    lblKitType.Text = AntiXssEncoder.HtmlEncode(activity.WKF_CASE.STD_WKFCASETYPE.CODE, false);
                    if (lblKitType.Text.ToUpper() == "FRAGMENT ANALYSIS")
                    {
                        lblFormType.Text = "Fragment Collection Form Received";
                        lblFormType.AssociatedControlID = radQstnrReceived.ID;
                    }
                    if (DDLShippingStatus.Items.Count <= 1)
                    {
                        List<VIRP.EFR.BO.STD_SHIPMENTSTS> shipSts = VIRP.EFR.BLL.STD_SHIPMENTSTSManager.GetItems(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                        if (shipSts != null)
                            DDLShippingStatus.Items.AddRange(shipSts.Where(w => w.INACTIVE_FLAG == false).Select(t => new ListItem(t.CODE, t.ID.ToString())).ToArray());
                        //DDLShippingStatus.Items.AddRange(DropDownLists.GetShippingStatus().Select(t => new ListItem(t.Value, t.Key.ToString())).ToArray());
                    }

                    //if (activity.SHIPPING_DETAILs.Count() == 0)
                    //{
                    //    //Store the order type 
                    //    ViewState["OrderType"] = activitySt.ID;
                    //    txtRetVAMCContact.Text = activity.WKF_CASE.REFERRAL.VAMC_CONTACT_NAME;
                    //}
                    //else
                    //{
                    //    //Store the order type 
                    //    ViewState["OrderType"] = activitySt.ID;

                    //    txtRetVAMCContact.Text = activity.SHIPPING_DETAILs[0].REPRESENTATIVE_NAME;
                    //    txtRetCourierNumber.Text = activity.SHIPPING_DETAILs[0].TRACKING_NUMBER;
                    //    KitSentDate.Text = (activity.SHIPPING_DETAILs[0].SEND_DATE.HasValue ? activity.SHIPPING_DETAILs[0].SEND_DATE.GetValueOrDefault().ToShortDateString() : "");

                    //    KitReceivedDate.Text = (activity.SHIPPING_DETAILs[0].RECEIVED_DATE.HasValue ? activity.SHIPPING_DETAILs[0].RECEIVED_DATE.GetValueOrDefault().ToShortDateString() : "");

                    //    radQstnrReceived.SelectedValue = activity.SHIPPING_DETAILs[0].SURVEY_RECEIVED_FLAG ? "1" : "0";

                    //    if (resetReason)
                    //    {
                    //        DDLShippingStatus.SelectedValue = "0";
                    //        txtRetOther.Text = String.Empty;
                    //    }
                    //    else
                    //    {
                    //        if (activity.SHIPPING_DETAILs[0].STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.PatientRefused) || activity.SHIPPING_DETAILs[0].STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.Other)) //Todo - use enum
                    //        {
                    //            DDLShippingStatus.SelectedValue = (activity.SHIPPING_DETAILs.First().STD_SHIPMENTSTS_ID ?? 0).ToString();
                    //            txtRetOther.Text = activity.SHIPPING_DETAILs[0].COMMENT_TEXT;
                    //            KitReceivedDate.Enabled = false;
                    //        }
                    //    }
                    //}

                    VIRP.EFR.BO.SHIPPING_DETAIL ship = VIRP.EFR.BLL.SHIPPING_DETAILManager.GetItemsByActivity(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID).FirstOrDefault();
                    if (ship != null)
                    {
                        txtRetVAMCContact.Text = ship.REPRESENTATIVE_NAME;
                        txtRetCourierNumber.Text = ship.TRACKING_NUMBER;
                        KitSentDate.Text = (ship.SEND_DATE.HasValue ? ship.SEND_DATE.GetValueOrDefault().ToShortDateString() : "");

                        KitReceivedDate.Text = (ship.RECEIVED_DATE.HasValue ? ship.RECEIVED_DATE.GetValueOrDefault().ToShortDateString() : "");

                        radQstnrReceived.SelectedValue = ship.SURVEY_RECEIVED_FLAG ? "1" : "0";

                        if (resetReason)
                        {
                            DDLShippingStatus.SelectedValue = "0";
                            txtRetOther.Text = String.Empty;
                        }
                        else
                        {
                            if (ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.PatientRefused) || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.Other)) //Todo - use enum
                            {
                                DDLShippingStatus.SelectedValue = (ship.STD_SHIPMENTSTS_ID ?? 0).ToString();
                                txtRetOther.Text = ship.COMMENT_TEXT;
                                KitReceivedDate.Enabled = false;
                            }
                        }
                    }
                }

                SetUpButtons(activity);

                LabKitWorkflowStatus.Value = activity.STD_WKFACTIVITYSTS_ID.ToString();

                BreadCrumbLbl.Value = AntiXssEncoder.HtmlEncode("My Tasks > Lab Kits > " + activitySt.NAME.Replace("ORDERED", "TRACKING") + " > Workflow ID " + wCase.WKF_CASE_ID, false);
                ((Label)Master.FindControl("EfrPageTitle")).Text = BreadCrumbLbl.Value;

                WkfCase = wCase;
            }
        }

        protected void BtnCancel_Click(object sender, EventArgs e)
        {
            RedirectToReferringPage();
        }

        private void SetUpButtons(WKF_CASE_ACTIVITY activity)
        {
            switch (activity.STD_WKFACTIVITYSTS_ID)
            {
                case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Tracking:

                    KitReceivedDateRequiredValidator.IsValid = ShippingStatusValidator.IsValid = true;
                    KitReceivedDateRequiredValidator.Enabled = ShippingStatusValidator.Enabled = true;

                    BtnVoid.Enabled = BtnReceive.Enabled = true;
                    BtnSave.Text = "Save";
                    DDLShippingStatus.Enabled = true;
                    txtRetOther.Enabled = true;
                    break;

                case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided:

                    ShippingStatusValidator.Enabled = KitReceivedDateRequiredValidator.Enabled = false;
                    BtnVoid.Enabled = BtnReceive.Enabled = false;
                    BtnSave.Text = "Un-Void";
                    DDLShippingStatus.Enabled = false;
                    txtRetOther.Enabled = false;
                    break;

                case (int)VIRP.EFR.BO.WorkflowCaseActivityStatus.Received:

                    KitReceivedDateRequiredValidator.IsValid = true;
                    KitReceivedDateRequiredValidator.Enabled = true;
                    ShippingStatusValidator.Enabled = false;
                    BtnVoid.Enabled = BtnReceive.Enabled = false;
                    BtnSave.Text = "Save";
                    DDLShippingStatus.Enabled = false;
                    txtRetOther.Enabled = false;

                    break;

                default:

                    BtnVoid.Enabled = BtnReceive.Enabled = true;
                    BtnSave.Text = "Save";
                    break;
            }
        }

        protected void BtnReceive_Click(object sender, EventArgs e)
        {
            //wCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["WCase"]);
            WKF_CASE wCase = WkfCase;
            if (wCase != null)
            {
                //activity = wCase.WKF_CASE_ACTIVITies[0];
                WKF_CASE_ACTIVITY activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, wCase.WKF_CASE_ID).FirstOrDefault();
                if (activity == null)
                {
                    activity = new WKF_CASE_ACTIVITY();
                    activity.CREATED = activity.UPDATED = DateTime.Now;
                    activity.CREATEDBY = activity.UPDATEDBY = CurrentUser;
                }

                activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Received);

                activity.KIT_ORDER_DATE = Helpers.ToNullable<DateTime>(KitOrderedDate.Text.Trim()); //TODO - Add a new field to db tanle and use it
                activity.KIT_USE_STOCK_FLAG = LabelOrderedFromStock.Text == "Yes";
                activity.REPRESENTATIVE_NAME = lblTEFSCRep.Text;
                activity.CONTACT_NAME = txtVAMCRep.Text;
                activity.ADDRESS_LINE1 = txtAddressPart1.Text;
                activity.ADDRESS_LINE2 = txtAddressPart2.Text;
                activity.ADDRESS_LINE3 = txtAddressPart3.Text;
                activity.STATE = txtState.Text;
                activity.CITY = txtCity.Text;
                activity.POSTAL_CODE = txtZip.Text;
                activity.COUNTRY = txtCountry.Text;
                activity.CONTACT_PHONE = txtPhone.Text;

                activity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity);
                //activity.SetAsChangeTrackingRoot(true);

                //Save ship details
                VIRP.EFR.BO.SHIPPING_DETAIL ship = VIRP.EFR.BLL.SHIPPING_DETAILManager.GetItemsByActivity(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID).FirstOrDefault();
                if (ship == null)
                {
                    ship = new VIRP.EFR.BO.SHIPPING_DETAIL();
                }

                //SHIPPING_DETAIL ship = null;
                //if (activity.SHIPPING_DETAILs.Count() != 0)
                //{   //Already exists
                //    ship = activity.SHIPPING_DETAILs[0];
                //    activity.SetAsUpdateOnSubmit(true);
                //}
                //else
                //{
                //    ship = new SHIPPING_DETAIL();
                //    activity.SHIPPING_DETAILs.Add(ship);
                //    ship.SetAsChangeTrackingRoot(EntityState.New, true);
                //    ship.SetAsInsertOnSubmit();
                //    activity.SetAsUpdateOnSubmit();
                //}

                ship.STD_REGISTRY_ID = UserSession.CurrentRegistryId;
                ship.WKF_CASE_ACTIVITY_ID = activity.WKF_CASE_ACTIVITY_ID;

                if (int.Parse(DDLShippingStatus.SelectedValue) > 0)
                {
                    ship.STD_SHIPMENTSTS_ID = Helpers.ToNullable<int>(DDLShippingStatus.SelectedValue);
                }
                ship.REPRESENTATIVE_NAME = txtRetVAMCContact.Text;
                ship.TRACKING_NUMBER = txtRetCourierNumber.Text;
                ship.SEND_DATE = Helpers.ToNullable<DateTime>(KitSentDate.Text);
                //Client side script changing the value to null. But does not work. 
                if (ship.STD_SHIPMENTSTS_ID != null)
                    KitReceivedDate.Text = "";
                ship.RECEIVED_DATE = Helpers.ToNullable<DateTime>(KitReceivedDate.Text);
                ship.SURVEY_RECEIVED_FLAG = (int.Parse(radQstnrReceived.SelectedValue) == 1);
                //Two entities- ship and activity
                if (ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.PatientRefused) || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.KitLost) || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.Other)) ship.COMMENT_TEXT = txtRetOther.Text;

                ship.SHIPPING_DETAIL_ID = VIRP.EFR.BLL.SHIPPING_DETAILManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, ship);

                OpenCloseReferralAndWorkflowCase(wCase, () => "Receive");

                UpdateKitActivity(wCase, activity, ship, () => true);

                BindData(activity.WKF_CASE_ACTIVITY_ID, false);

                SetSaveSuccessMessage();
            }
        }

        protected void BtnVoid_Click(object sender, EventArgs e)
        {
            //wCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["WCase"]);
            WKF_CASE wCase = WkfCase;
            if (wCase != null)
            {
                //activity = wCase.WKF_CASE_ACTIVITies[0];
                WKF_CASE_ACTIVITY activity = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, wCase.WKF_CASE_ID).FirstOrDefault();
                if (activity == null)
                {
                    activity = new WKF_CASE_ACTIVITY();
                    activity.CREATED = activity.UPDATED = DateTime.Now;
                    activity.CREATEDBY = activity.UPDATEDBY = CurrentUser;
                }

                activity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.Voided);

                activity.KIT_ORDER_DATE = Helpers.ToNullable<DateTime>(KitOrderedDate.Text.Trim()); //TODO - Add a new field to db tanle and use it
                activity.KIT_USE_STOCK_FLAG = LabelOrderedFromStock.Text == "Yes";
                activity.REPRESENTATIVE_NAME = lblTEFSCRep.Text;
                activity.CONTACT_NAME = txtVAMCRep.Text;
                activity.ADDRESS_LINE1 = txtAddressPart1.Text;
                activity.ADDRESS_LINE2 = txtAddressPart2.Text;
                activity.ADDRESS_LINE3 = txtAddressPart3.Text;
                activity.STATE = txtState.Text;
                activity.CITY = txtCity.Text;
                activity.POSTAL_CODE = txtZip.Text;
                activity.COUNTRY = txtCountry.Text;
                activity.CONTACT_PHONE = txtPhone.Text;

                activity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity);
                //activity.SetAsChangeTrackingRoot(true);

                //Save ship details
                VIRP.EFR.BO.SHIPPING_DETAIL ship = VIRP.EFR.BLL.SHIPPING_DETAILManager.GetItemsByActivity(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID).FirstOrDefault();
                if (ship == null)
                {
                    ship = new VIRP.EFR.BO.SHIPPING_DETAIL();
                }

                //SHIPPING_DETAIL ship = null;
                //if (activity.SHIPPING_DETAILs.Count() != 0)
                //{   //Already exists
                //    ship = activity.SHIPPING_DETAILs[0];
                //    activity.SetAsUpdateOnSubmit(true);
                //}
                //else
                //{
                //    ship = new SHIPPING_DETAIL();
                //    activity.SHIPPING_DETAILs.Add(ship);
                //    ship.SetAsChangeTrackingRoot(EntityState.New, true);
                //    ship.SetAsInsertOnSubmit();
                //    activity.SetAsUpdateOnSubmit();
                //}

                ship.STD_REGISTRY_ID = UserSession.CurrentRegistryId;
                ship.WKF_CASE_ACTIVITY_ID = activity.WKF_CASE_ACTIVITY_ID;

                if (int.Parse(DDLShippingStatus.SelectedValue) > 0)
                {
                    ship.STD_SHIPMENTSTS_ID = Helpers.ToNullable<int>(DDLShippingStatus.SelectedValue);
                }
                ship.REPRESENTATIVE_NAME = txtRetVAMCContact.Text;
                ship.TRACKING_NUMBER = txtRetCourierNumber.Text;
                ship.SEND_DATE = Helpers.ToNullable<DateTime>(KitSentDate.Text);
                //Client side script changing the value to null. But does not work. 
                if (ship.STD_SHIPMENTSTS_ID != null)
                    KitReceivedDate.Text = string.Empty;
                ship.RECEIVED_DATE = Helpers.ToNullable<DateTime>(KitReceivedDate.Text);
                ship.SURVEY_RECEIVED_FLAG = (int.Parse(radQstnrReceived.SelectedValue) == 1);
                //Two entities- ship and activity
                if (ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.PatientRefused) || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.KitLost) || ship.STD_SHIPMENTSTS_ID == Convert.ToInt16(StdShipmentStatus.Other))
                    ship.COMMENT_TEXT = txtRetOther.Text;

                ship.SHIPPING_DETAIL_ID = VIRP.EFR.BLL.SHIPPING_DETAILManager.Save(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, ship);

                OpenCloseReferralAndWorkflowCase(wCase, () => "Void");

                UpdateKitActivity(wCase, activity, ship, () => false);

                BindData(activity.WKF_CASE_ACTIVITY_ID, false);

                SetSaveSuccessMessage();
            }
        }

        protected void BtnSimulate_Click(object sender, EventArgs e)
        {
            //wCase = SerializerUtil.Deserialize<WKF_CASE>((string)ViewState["WCase"]);
            WKF_CASE wCase = WkfCase;
            if (wCase != null)
            {
                if (wCase.STD_WKFCASETYPE_ID == Convert.ToInt16(VIRP.EFR.BO.WorkFlowTypes.Biomonitoring))
                {
                    VIRP.EFR.BLL.ANALYSIS_DETAILManager.LoadBioLabResults(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, wCase.WKF_CASE_ID);
                }
            }
        }
        
        private void OpenCloseReferralAndWorkflowCase(WKF_CASE parentCase, Func<string> operation)
        {
            //ReferralManager rm = new ReferralManager();
            //EFR_REFERRAL parentReferral = rm.getReferralByReferralID(parentCase.REFERRAL_ID.Value);
            //parentReferral = SerializerUtil.Deserialize<EFR_REFERRAL>(parentReferral.Serialize());
            //parentReferral.SetAsChangeTrackingRoot();
            VIRP_WEB.SoaServices.REFERRAL parentReferral = ServiceInterfaceManager.REFERRAL_GET(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentCase.REFERRAL_ID.GetValueOrDefault());
            if (parentReferral != null)
            {
                if (operation() == "Void")
                {
                    List<WKF_CASE> cases = ServiceInterfaceManager.WKF_CASE_GET_ALL_BY_REFERRAL(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentReferral.REFERRAL_ID);
                    if (cases != null)
                    {
                        bool blnIncomplete = false;
                        foreach (WKF_CASE c in cases)
                        {
                            if (c.WKF_CASE_ID != parentCase.WKF_CASE_ID && c.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed)
                            {
                                blnIncomplete = true;
                                break;
                            }
                        }
                        if (!blnIncomplete)
                            parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.Completed;
                    }

                    parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed;
                    //var items = parentReferral.WKF_CASEs.Except(new List<WKF_CASE> { parentCase }, new WorkflowCaseManager.WorkflowCaseComparer());

                    //if (items.Count(a => a.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed) == 0)
                    //    parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.Completed;

                    //parentReferral.WKF_CASEs.Where(c => c.WKF_CASE_ID == parentCase.WKF_CASE_ID).First().STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.Completed;
                }
                else
                {
                    if (parentReferral.STD_REFERRALSTS_ID != (int)VIRP.EFR.BO.ReferralStatus.InProcess)
                        parentReferral.STD_REFERRALSTS_ID = (int)VIRP.EFR.BO.ReferralStatus.InProcess;

                    if (parentCase.STD_WKFCASESTS_ID != (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess)
                        parentCase.STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess;
                        //parentReferral.WKF_CASEs.Where(c => c.WKF_CASE_ID == parentCase.WKF_CASE_ID).First().STD_WKFCASESTS_ID = (int)VIRP.EFR.BO.WorkFlowCaseStatus.InProcess;
                }

                SuppressSaveSuccessMessage = true;
                //rm.Update(parentReferral);
                parentCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentCase);
                parentReferral.REFERRAL_ID = ServiceInterfaceManager.REFERRAL_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, parentReferral);

                SuppressSaveSuccessMessage = false;
            }
        }

        private void UpdateKitActivity(WKF_CASE wCase, WKF_CASE_ACTIVITY activity, VIRP.EFR.BO.SHIPPING_DETAIL ship, Func<bool> checkDups)
        {
            if (ship != null)
            {
                if (ship.SURVEY_RECEIVED_FLAG == true && !ActivityExists(wCase.WKF_CASE_ID, VIRP.EFR.BO.WorkFlowActivityTypes.Questionnaire) && checkDups())
                    InitiateActivity(activity, VIRP.EFR.BO.WorkFlowActivityTypes.Questionnaire);

                if (ship.RECEIVED_DATE != null && !ActivityExists(wCase.WKF_CASE_ID, VIRP.EFR.BO.WorkFlowActivityTypes.LabOrder) && checkDups())
                    InitiateActivity(activity, VIRP.EFR.BO.WorkFlowActivityTypes.LabOrder);
            }

            wCase.WKF_CASE_ID = ServiceInterfaceManager.WKF_CASE_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, wCase);
            WkfCase = wCase;
        }

        private void InitiateActivity(WKF_CASE_ACTIVITY activity, VIRP.EFR.BO.WorkFlowActivityTypes type)
        {
            WKF_CASE_ACTIVITY NewActivity = new WKF_CASE_ACTIVITY();
            //NewActivity.WKF_CASE_ID = Activity.WKF_CASE_ID;
            NewActivity.CREATED = NewActivity.UPDATED = DateTime.Now;
            NewActivity.CREATEDBY = NewActivity.UPDATEDBY = CurrentUser;
            NewActivity.WKF_CASE_ID = activity.WKF_CASE_ID;
            NewActivity.STD_WKFACTIVITYTYPE_ID = Convert.ToInt16(type);
            NewActivity.STD_WKFACTIVITYSTS_ID = Convert.ToInt16(VIRP.EFR.BO.WorkflowCaseActivityStatus.New);
            NewActivity.REPRESENTATIVE_NAME = activity.REPRESENTATIVE_NAME;
            NewActivity.CONTACT_NAME = activity.CONTACT_NAME;
            NewActivity.WKF_CASE_ACTIVITY_ID = ServiceInterfaceManager.WKF_CASE_ACTIVITY_SAVE(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, NewActivity);
        }

        private bool ActivityExists(int wkfId, VIRP.EFR.BO.WorkFlowActivityTypes type)
        {
            List<WKF_CASE_ACTIVITY> activities = ServiceInterfaceManager.WKF_CASE_ACTIVITY_GET_ALL_BY_WORKSTREAM(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, wkfId);

            if (activities != null)
            {
                foreach (WKF_CASE_ACTIVITY act in activities)
                {
                    if (act.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(type))
                        return true;
                }
            }

            return false;
        }
    }
}
